;Multicore Cable Tester September 2004

;Program operates as a loop testing the cable. One byte is used to store the status of the findings.
;When any bit of this byte is high, the report subroutine is called

;Port Assignments
;----------------
;Port A,0	OUTPUT	Shift Register Clear
;Port A,1	OUTPUT	Shift Register Clock
;Port A,2	OUTPUT	Shift Register Data
;Port A,3	OUTPUT	Piezo Sounder
;Port A,4	OUTPUT	Crossover LED
;Port B,0	Input/Output to Cable
;Port B,1	Input/Output to Cable
;Port B,2	Input/Output to Cable
;Port B,3	Input/Output to Cable
;Port B,4	Input/Output to Cable
;Port B,5	Input/Output to Cable
;Port B,6	Input/Output to Cable
;Port B,7	Input/Output to Cable

W:	.EQU $00	;working register
OPTION: .EQU $01        ;
STATUS: .EQU $03        ;
PORTA:  .EQU $05        ;
PORTB:  .EQU $06        ;
INTCON: .EQU $0B        ;
RESULT:	.EQU $10
COUNT:	.EQU $11
DELAY:	.EQU $12
DELAY1:	.EQU $13
COUNT1:	.EQU $14
RESCPY:	.EQU $15
CONFIG:	.EQU $16
FLAG1:	.EQU $17

	.org 4
	.org 5

	clrf PORTA      ;
	clrf PORTB	;
	BSF STATUS,5	;Page 1 memory addressing
	CLRF PORTB	;set PORT B as all output
	COMF PORTB,1	;complement it so they are all input
	CLRF PORTA	;set PORT A as all output
	BCF STATUS,5	;Page 0 memory addressing

	bsf PORTA,0	;clear shift register
	bcf PORTA,0	;ditto
	bsf PORTA,0	;ditto
	bcf PORTA,3	;clear sounder
	clrf FLAG1	;clear all flags

	CALL STRT	;call STARTUP Routine to test LEDs and sounder
	bsf PORTA,4	;enable crossover LED

test:	clrf RESULT	;clear RESULT
	bcf FLAG1,0	;clear loop control flag
retest:	movlw %11111110	;test 1 of 8
	CALL tstbit
	movlw %11111101	;test 2 of 8
	CALL tstbit
	movlw %11111011	;test 3 of 8
	CALL tstbit
	movlw %11110111	;test 4 of 8
	CALL tstbit
	movlw %11101111	;test 5 of 8
	CALL tstbit
	movlw %11011111	;test 6 of 8
	CALL tstbit
	movlw %10111111	;test 7 of 8
	CALL tstbit
	movlw %01111111	;test 8 of 8
	CALL tstbit
	btfsc FLAG1,0	;check to see if on a previous loop FLAG1,0 was set high
	goto report	;and if so, goto report
	movf RESULT,0	;move results to working register
	movwf RESCPY	;and to destructable copy
	clrf COUNT	;clear COUNT
chklp:	btfsc RESCPY,0	;check to see if bit 0 is set
	bsf FLAG1,0	;and if it is, set FLAG1,0
	rrf RESCPY,1	;rotate RESCPY to the right
	incf COUNT,1	;increment COUNT
	btfss COUNT,3	;check bit 3 of COUNT to see if all bits checked
	GOTO chklp	;and loop round again if not
	btfss flag1,0	;					;these two lines reset the report flag if there is no cable plugged in
	bcf flag1,1	
	goto retest
	
report:	btfsc FLAG1,1	;check to see if report already made
	goto test	;skip this routine if it has
	bsf FLAG1,1	;set "report flag"
	call BEEP	;beep the sounder
	call DISP	;display the results
	clrf COUNT	;clear COUNT
	movf RESULT,0	;copy RESULT to working register
	movwf RESCPY	;and there to destructable copy
rptbp:	CALL DEL1	;insert gap between cable recognised beep and beeping core 1
	CALL BEEP
	btfsc RESCPY,0	;check to see if bit 0 high
	CALL BEEP	;do double beep if so
	CALL DEL1	;pause
	rrf RESCPY,1	;rotate RESCPY to the right
	incf COUNT,1	;increment count
	btfss COUNT,3	;check bit 3 of count to see if enough beeps have been made
	goto rptbp	;and loop around again if not
	call XTEST
	goto test

;-------CROSSOVER TEST SUBROUTINE----------------------------------------------------------

XTEST:	bcf PORTA,4
	movlw %01011010
	bsf STATUS,5	;Page 1 memory addressing
	movwf PORTB	;configure PORT B inputs and outputs
	bcf STATUS,5	;Page 0 memory addressing
	movwf PORTB	;configure PORT B with data -
	comf PORTB,1	;set the relevant bit high so the test can be carried out
	CALL DEL3	;call settling time delay to prevent erroneous results
	btfsc PORTB,6
	bsf PORTA,4
	btfsc PORTB,4
	bsf PORTA,4
	btfsc PORTB,3
	bsf PORTA,4
	btfsc PORTB,1
	bsf PORTA,4
	RETURN

;-------TESTBIT SUBROUTINES----------------------------------------------------------------

tstbit:	bsf STATUS,5	;Page 1 memory addressing
	movwf PORTB	;configure PORT B inputs and outputs
	bcf STATUS,5	;Page 0 memory addressing
	movwf PORTB	;configure PORT B with data -
	comf PORTB,1	;set the relevant bit high so the test can be carried out
	CALL DEL3	;call settling time delay to prevent erroneous results
	movwf COUNT	;move test mask into COUNT
	andwf PORTB,0	;AND the data from Port B to the working register so as to mask the active high output
	iorwf RESULT,1	;inclusive OR the results with those already obtained
	;----------This next part of the subroutine plugs a hole in the original logic. If, for example, only two
	;----------cores work and they are either side of the patch/xover detection diode, only one core will be
	;----------recognised. This next part allows the "live" core being tested at this time to be recognised
	;----------as functional providing another core has been - reversing the masking of the active high above.
	movwf RESCPY	;move the captured and masked data from the working register - this is the results of this individual test
	comf COUNT,0	;compliment COUNT so that the 1 indicates the active output and put the result in w
	bcf flag1,3	;clear flag
	clrf COUNT1	;clear COUNT1
tstlp:	btfsc RESCPY,0	;check for a 1 in bit 0
	bsf flag1,3	;and if so, set this flag high
	rrf RESCPY,1	;rotate RESCPY to the right
	incf COUNT1,1	;increment COUNT1
	btfss COUNT1,3	;check bit 3 to see if all bits checked
	goto tstlp	;and if not, go around again
	btfsc flag1,3	;test to see if any results found in this test, and if so,...
	iorwf RESULT,1	;inclusive OR the inverted mask with the RESULTS so far
	RETURN

;-------DELAY SUBROUTINES------------------------------------------------------------------

DEL1:	clrf DELAY
	comf DELAY,1
DEL2:	call DEL3
	decfsz DELAY,1
	goto DEL2
	RETURN

DEL3:	clrf DELAY1
	comf DELAY1,1
DEL4:	decfsz DELAY1,1
	goto DEL4
	RETURN

;-------LED DISPLAY SUBROUTINE-------------------------------------------------------------

DISP:	bsf PORTA,0	;clear display
	bcf PORTA,0	;
	bsf PORTA,0	;
	clrf COUNT	;clear COUNT
	movf RESULT,0	;move RESULT to working register
	movwf RESCPY	;and then to RESCPY
DLP:	btfsc RESCPY,0	;test bit 0 of the RESCPY register
	bsf PORTA,2	;and if high, set data to shift register high
	bsf PORTA,1	;clock shift register
	bcf PORTA,1	;
	bcf PORTA,2	;clear data to shift register
	rrf RESCPY,1	;rotate RESCPY one bit to the right
	incf COUNT,1	;increment COUNT
	btfss COUNT,3	;check bit 3 of COUNT to see if enough bits have been sent
	GOTO DLP	;and if not, loop back to DLP
	RETURN

;-------BEEP SUBROUTINE--------------------------------------------------------------------

BEEP:	bsf PORTA,3
	CALL DEL1
	bcf PORTA,3
	RETURN

;-------STARTUP SUBROUTINES----------------------------------------------------------------

STRT:	clrf COUNT1	;clear count1
	movlw %00000001	;set up literal number
	movwf RESULT	;into result
	bsf STATUS,5	;Page 1 memory addressing
	clrf PORTB	;set PORTB as all outputs
	bcf STATUS,5	;Page 0 memory addressing		
STRTL:	CALL DISP	;display it	
	;movf RESULT,0	;copy the current value of RESULT into the working register
	movwf PORTB	;configure PORT B with data that corresponds to the LED display
	CALL BEEP	;sound a beep
	CALL DEL1	;wait
	CALL DEL1	;wait some more
	rlf RESULT,1	;rotate result once to the right
	incf COUNT1,1	;increment COUNT1
	btfss COUNT1,3	;check bit 3 of COUNT1 to see if routine should complete
	GOTO STRTL	;loop again if not
	bsf PORTA,0	;clear display
	bcf PORTA,0	;
	bsf PORTA,0	;
	RETURN

;------------------------------------------------------------------------------------------


.END